<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Retrieve the form data
    $pack_type = isset($_POST['pack_type']) ? $_POST['pack_type'] : '';
    $adults = isset($_POST['adults']) ? $_POST['adults'] : '';
    $children = isset($_POST['child_5_12']) ? $_POST['child_5_12'] : '';
    $infants = isset($_POST['infant']) ? $_POST['infant'] : '';
    $flight_class = isset($_POST['flight_class']) ? $_POST['flight_class'] : '';
    $place_from = isset($_POST['place_from']) ? $_POST['place_from'] : '';
    $place_to = isset($_POST['place_to']) ? $_POST['place_to'] : '';
    $depart_date = isset($_POST['depart_date']) ? $_POST['depart_date'] : '';
    $return_date = isset($_POST['return_date']) ? $_POST['return_date'] : '';
    $cname = isset($_POST['cname']) ? $_POST['cname'] : '';
    $cemail = isset($_POST['cemail']) ? $_POST['cemail'] : '';
    $cphone = isset($_POST['cphone']) ? $_POST['cphone'] : '';

    // Validate the email
    if (!filter_var($cemail, FILTER_VALIDATE_EMAIL)) {
        echo "Invalid email format";
        exit;
    }

    // Email to send to
    $to = "info@legionfly.com";
    
    // Subject
    $subject = "New Flight Inquiry: " . $cname;

    // Message body
    $message = "
    <html>
    <head>
        <title>Flight Inquiry</title>
    </head>
    <body>
        <h3>New Flight Inquiry</h3>
        <p><strong>Trip Type:</strong> " . ($pack_type == 1 ? 'One Way' : 'Round Trip') . "</p>
        <p><strong>Adults:</strong> $adults</p>
        <p><strong>Children:</strong> $children</p>
        <p><strong>Infants:</strong> $infants</p>
        <p><strong>Flight Class:</strong> $flight_class</p>
        <p><strong>From:</strong> $place_from</p>
        <p><strong>To:</strong> $place_to</p>
        <p><strong>Departure Date:</strong> $depart_date</p>
        <p><strong>Return Date:</strong> $return_date</p>
        <p><strong>Name:</strong> $cname</p>
        <p><strong>Email:</strong> $cemail</p>
        <p><strong>Phone:</strong> $cphone</p>
    </body>
    </html>
    ";

    // Headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8" . "\r\n";
    $headers .= "From: $cemail" . "\r\n";  // Sender's email

    // Send the email
    if (mail($to, $subject, $message, $headers)) {
        echo "Success";
    } else {
        echo "Error";
    }

} else {
    echo "Invalid Request";
}
?>
