

  function initializeFlightForm() {
    // Datepickers
    $("#datepicker").datepicker({
      numberOfMonths: 1,
      minDate: 0,
      changeMonth: true,
      changeYear: true,
      onSelect: function(selectedDate) {
        $("#datepicker2").datepicker("option", "minDate", selectedDate);
      }
    });

    $("#datepicker2").datepicker({
      numberOfMonths: 1,
      minDate: 0,
      changeMonth: true,
      changeYear: true,
      onSelect: function(selectedDate) {
        $("#datepicker").datepicker("option", "maxDate", selectedDate);
      }
    });

    // Disable return date for one-way
    function toggleReturnDate() {
      const isOneWay = $('input[name="pack_type"]:checked').val() === "1";
      $('#datepicker2').prop('disabled', isOneWay).val('');
    }

    toggleReturnDate();
    $('input[name="pack_type"]').on('change', toggleReturnDate);

    // Traveler toggle
    $('.toggle').on('click', function() {
      $('#target').fadeToggle(200);
    });

    $('#closebtn').on('click', function() {
      $('#target').fadeOut(200);
    });

    // Autocomplete
    $('#country, #country2').typeahead({
      source: function (query, process) {
        return $.ajax({
          url: "/airport.php",
          type: 'POST',
          data: { query: query },
          dataType: 'json',
          success: function (result) {
            return process(result);
          }
        });
      }
    });
  }

  $(document).ready(function() {
    initializeFlightForm(); // Call init on page load
  });

  // Increment / Decrement passenger count
  $('.button-plus').click(function (e) {
    e.preventDefault();
    var fieldName = $(this).attr('data-field');
    var parent = $(this).closest('.input-group');
    var input = parent.find('input[name=' + fieldName + ']');
    var currentVal = parseInt(input.val(), 10);
    if (!isNaN(currentVal)) {
      input.val(currentVal + 1).change();
    }
  });

  $('.button-minus').click(function (e) {
    e.preventDefault();
    var fieldName = $(this).attr('data-field');
    var parent = $(this).closest('.input-group');
    var input = parent.find('input[name=' + fieldName + ']');
    var currentVal = parseInt(input.val(), 10);
    if (!isNaN(currentVal) && currentVal > 0) {
      input.val(currentVal - 1).change();
    }
  });

function updateTravelerSummary() {
    var adults = parseInt($('input[name="adults"]').val(), 10) || 0;
    var children = parseInt($('input[name="child_5_12"]').val(), 10) || 0;
    var infants = parseInt($('input[name="infant"]').val(), 10) || 0;
    var total = adults + children + infants;

    var flightClass = $('input[name="flight_class"]:checked').val();

    let summary = flightClass + ' ' + total + ' traveler' + (total > 1 ? 's' : '');
    $('.toggle').text(summary);
  }

  // Trigger summary update on input change
  $('input[name="adults"], input[name="child_5_12"], input[name="infant"]').on('change keyup', updateTravelerSummary);
  $('input[name="flight_class"]').on('change', updateTravelerSummary);

  // Also update on plus/minus click
  $('.button-plus, .button-minus').on('click', function () {
    setTimeout(updateTravelerSummary, 100); // Delay to let input update
  });

  // Initial call on load
  $(document).ready(updateTravelerSummary);
