	<!-- Cookie Policy Popup HTML -->
<div id="cookie-popup" class="cookie-popup" style="display:none;">
    <div class="cookie-popup-content">
        <p class="cookie-text">By utilizing our website, you agree to the utilization of Cookies as outlined in our Cookie Policy. These files are intended to improve your overall browsing <a href="/cookie.php" target="_blank">Experience.</a>.</p>
        <div class="cookie-buttons">
            <button id="accept-cookies" class="cookie-btn accept-btn">Accept</button>
            <button id="decline-cookies" class="cookie-btn decline-btn">Deny</button>
        </div>
    </div>
</div>


<style>
.cookie-popup {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background-color: #fff;
    border-radius: 0;
    padding: 15px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-family: Arial, sans-serif;
    font-size: 14px;
}

.cookie-popup-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    max-width: 1200px;
    margin: 0 auto;
}

.cookie-text {
    flex: 1;
    text-align: left;
    margin-right: 20px;
}

.cookie-popup a {
    color: #1a374d;
    text-decoration: underline;
}

.cookie-buttons {
    display: flex;
    justify-content: space-between;
    gap: 10px;
}

.cookie-btn {
    padding: 10px 15px;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    border: none;
}

.accept-btn {
    background-color: #1a374d;
    color: white;
}

.decline-btn {
    background-color: #6998ab;
    color: white;
}

@media only screen and (max-width: 600px) {
    .cookie-popup {
        width: 100%;
        bottom: 0;
        left: 0;
        transform: none;
        border-radius: 0;
        padding: 10px;
    }

    .cookie-popup-content {
        flex-direction: column;
        align-items: center;
    }

    .cookie-buttons {
        margin-top: 10px;
        justify-content: center;
        gap: 20px;
    }
}

</style>

<!-- Cookie Policy Popup JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const cookiePopup = document.getElementById('cookie-popup');
    const acceptBtn = document.getElementById('accept-cookies');
    const declineBtn = document.getElementById('decline-cookies');

    // Check if a cookie decision was made (accepted or declined)
    if (!localStorage.getItem('cookieDecision')) {
        cookiePopup.style.display = 'block';
    }

    acceptBtn.addEventListener('click', function() {
        localStorage.setItem('cookieDecision', 'accepted');
        cookiePopup.style.display = 'none';
    });

    declineBtn.addEventListener('click', function() {
        localStorage.setItem('cookieDecision', 'declined');
        cookiePopup.style.display = 'none';
    });
});
</script>
 
 
 	