<style>

/* Enquiry Button Styles */
.enquiry-btn {
  background-color: #1a374d; /* Green button color */
  color: white;
  border: none;
  border-radius: 50px; /* Rounded corners */
  padding: 15px 25px;
  font-size: 18px;
  cursor: pointer;
  position: fixed;
  top: 50%; /* Vertically center it */
  right: -60px; /* Move it slightly outside of the right edge */
  transform: translateY(-50%) rotate(90deg); /* Rotate 90 degrees */
  box-shadow: 0px 4px 6px rgba(0,0,0,0.2); /* Optional shadow */
  transition: all 0.3s ease;
  z-index: 99;
}

.enquiry-btn:hover {
  background-color: #1a374d; /* Slightly darker green when hovered */
  box-shadow: 0px 6px 10px rgba(0,0,0,0.3);
}


/* Chatbot Button Styles */
    .chatbot-btn {
      background-color: #1a374d; /* Green button color */
      color: white;
      border: none;
      border-radius: 50px; /* Rounded corners */
      padding: 10px 20px;
      font-size: 26px;
      cursor: pointer;
      position: fixed;
      bottom: 60px;
      left: 15px;
      box-shadow: 0px 4px 6px rgba(0,0,0,0.2); /* Optional shadow */
      transition: all 0.3s ease;
      z-index: 99;
    }

    .chatbot-btn:hover {
      background-color: #1a374d; /* Slightly darker green when hovered */
      box-shadow: 0px 6px 10px rgba(0,0,0,0.3);
    }

    /* Chatbox Styles */
    .chatbox {
      position: fixed;
      bottom: 80px;
      left: 70px;
      width: 300px;
      height: 400px;
      background-color: #fff;
      border-radius: 10px;
      box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
      display: none;
      flex-direction: column;
      z-index: 999;
    }

    .chatbox-header {
      background-color: #1a374d;
      color: white;
      padding: 15px;
      font-size: 18px;
      border-radius: 10px 10px 0 0;
    }

    .chatbox-body {
      flex: 1;
      padding: 10px;
      overflow-y: auto;
      font-size: 14px;
      display: flex;
      flex-direction: column;
    }

    .chatbox-footer {
      padding: 10px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .user-input {
      width: 80%;
      padding: 8px;
      border-radius: 20px;
      border: 1px solid #ccc;
    }

    .send-btn {
      background-color: #1a374d;
      color: white;
      border: none;
      border-radius: 10%;
      padding: 10px;
      cursor: pointer;
    }

    .send-btn:hover {
      background-color: #1a374d;
    }

    .chat-message {
      margin: 5px 0;
    }

    .chat-message.bot {
      color: #1a374d;
      font-weight: bold;
    }

    .chat-message.user {
      text-align: right;
      color: #007BFF;
    }

    /* Expert Button inside the chatbox */
    .expert-btn {
      background-color: #008CBA; /* Blue button color */
      color: white;
      border: none;
      border-radius: 50px;
      padding: 10px 20px;
      font-size: 14px;
      cursor: pointer;
      width: 100%;
      margin-top: 10px;
      display: none;
    }

    .expert-btn:hover {
      background-color: #1a374d; /* Slightly darker blue when hovered */
    }


</style>


<!-- Chatbot Button -->
<button class="chatbot-btn" onclick="toggleChatbox()">
    <i class="icon-chat"></i>
</button>

<!-- Enquiry Button -->

<button class="enquiry-btn" onclick="window.location.href='/contact.php';">
    Enquiry Now
</button>



  <!-- Chatbox -->
  <div class="chatbox" id="chatbox">
    <div class="chatbox-header">
      <strong>Travel Assistant</strong>
      <button onclick="toggleChatbox()" style="background: none; border: none; color: white; font-size: 18px; cursor: pointer; margin-left:80px">&times;</button>
    </div>
    <div class="chatbox-body" id="chatbox-body">
      <!-- Chat messages will appear here -->
    </div>
    <div class="chatbox-footer">
      <input type="text" id="user-input" class="user-input" placeholder="Ask a question..." />
      <button class="send-btn" onclick="sendMessage()">Send</button>
    </div>
    <!-- Expert Button inside chatbox -->
    <button class="expert-btn" id="expert-btn" onclick="connectWithExpert()">Connect with Expert</button>
  </div>

  <script>
    // Add event listener for Enter key to send message
    document.getElementById("user-input").addEventListener("keydown", function(event) {
      if (event.key === "Enter" && !event.shiftKey) {
        event.preventDefault(); // Prevent default behavior (new line)
        sendMessage(); // Call sendMessage when Enter is pressed
      }
    });

    // Toggle chatbox visibility
    function toggleChatbox() {
      var chatbox = document.getElementById("chatbox");
      chatbox.style.display = (chatbox.style.display === "none" || chatbox.style.display === "") ? "flex" : "none";
    }

    // Send a message to the chatbot
    function sendMessage() {
      var userMessage = document.getElementById("user-input").value;
      if (!userMessage) return;

      // Display user's message in the chatbox
      displayMessage(userMessage, "user");

      // Get the bot's response
      var botResponse = getBotResponse(userMessage);

      // Display bot's response in the chatbox
      setTimeout(function() {
        displayMessage(botResponse, "bot");
      }, 500);

      // Clear the input field
      document.getElementById("user-input").value = "";
    }

    // Display message in the chatbox
    function displayMessage(message, sender) {
      var chatboxBody = document.getElementById("chatbox-body");
      var messageElement = document.createElement("div");
      messageElement.classList.add("chat-message", sender);
      messageElement.textContent = message;
      chatboxBody.appendChild(messageElement);

      // Scroll to the bottom
      chatboxBody.scrollTop = chatboxBody.scrollHeight;
    }

    // Get the chatbot's response based on the user's input
    function getBotResponse(userMessage) {
      var response = "";

      // Normalize the input message
      userMessage = userMessage.toLowerCase().trim();

      // Match keywords from user message
      if (userMessage.includes("hi") || userMessage.includes("hello")) {
        response = "Hello, How may I assist you?";
      } else if (userMessage.includes("book") && userMessage.includes("flight")) {
        response = "Effortlessly reserve a flight on our website by navigating to the 'Flight Booking' section. Fill in your travel information and proceed with the necessary steps to confirm your reservation.";
      } else if (userMessage.includes("change") && userMessage.includes("flight")) {
        response = "Yes, adjustments to flights are possible based on the airline's guidelines. Kindly provide us with your booking reference and we will help you with the alterations.";
      } else if (userMessage.includes("cancel") && userMessage.includes("flight")) {
        response = "To cancel your flight, you have two options: using our website or contacting our support team for help. Please note that the airline's policy may impose cancellation fees.";
      } else if (userMessage.includes("luggage")) {
        response = "Please review the baggage policy of your chosen airline during the booking process, as luggage allowances may differ depending on the airline and fare type.";
      } else if (userMessage.includes("tour") && userMessage.includes("package")) {
        response = "Our tour packages typically encompass transportation, lodging, accompanied outings, and select meals. You can refer to the comprehensive information on the dedicated tour page.";
      } else if (userMessage.includes("hotel") && userMessage.includes("booking") && userMessage.includes("change")) {
        response = "Absolutely, it all depends on the hotel’s specific policies for cancellations and modifications. Kindly provide us with your booking information, and we'll assist you with any necessary adjustments.";
      } else if (userMessage.includes("refund")) {
        response = "The eligibility for refunds is determined by the cancellation policy of the airline or hotel. If you qualify, we are able to assist with the refund process. Kindly share your booking information with us.";
      } else if (userMessage.includes("flight") && userMessage.includes("hotel") && userMessage.includes("together")) {
        response = "Indeed, we do have bundled packages available for both flights and hotels. By booking them together, you can take advantage of discounted rates.";
      } else if (userMessage.includes("airport") && userMessage.includes("transfers")) {
        response = "Absolutely, we are happy to help with booking airport transfers. Just inform us of your desired destination and we will take care of arranging transportation for you.";
      } else if (userMessage.includes("international") && userMessage.includes("flight")) {
        response = "Our services include booking flights to numerous international destinations across the globe. Just enter your chosen departure and arrival cities to browse through available flights.";
      } else if (userMessage.includes("quote") && userMessage.includes("customized") && userMessage.includes("tour")) {
        response = "Certainly! Kindly share with us your travel details, preferences, and any specific needs, and we will create a customized tour package just for you.";
      } else {
        response = "My apologies, I don't have the information for that. To get the answers you need, please connect with one of our experts and they will be more than willing to help you!";
        document.getElementById("expert-btn").style.display = "block"; // Show expert button inside chatbox
      }

      return response;
    }

    // Connect the user to an expert (Email or Call)
    function connectWithExpert() {
      var userChoice = confirm("Would you like to call our expert? Click 'OK' to call or 'Cancel' to email.");
      if (userChoice) {
        window.location.href = "tel:+1-804-689-2183"; // Direct call to the number
      } else {
        window.location.href = "mailto:support@legionfly.com"; // Example: Send email to support
      }
    }
  </script>

<script>
if (window.innerWidth <= 768) {
    document.querySelector('.call-button-container').style.display = 'block';
} else {
    document.querySelector('.call-button-container').style.display = 'none';
}
    
</script>



 